
const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;
#define vec2 float2
#define vec3 float3
#define vec4 float4
#define LINES_AND_FLICKER
#define BLOTCHES
#define GRAIN

#define FREQUENCY 5.0f

vec4 INPUTSRC(image2d_t src_data,__global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, tc).zyxw;
}

vec4 INPUT(image2d_t src_data, vec2 tc)
{
	return read_imagef(src_data, sampler, tc).zyxw;
}


float rand2(vec2 co){
	float temp; 
    return fract(sin(dot(co.xy ,(vec2)(12.9898f,78.233f))) * 43758.5453f, &temp);
}

float rand(float c){
	return rand2((vec2)(c,1.0f));
}

float randomLine(float seed, vec2 uv)
{
	float b = 0.01f * rand(seed);
	float a = rand(seed+1.0f);
	float c = rand(seed+2.0f) - 0.5f;
	float mu = rand(seed+3.0f);
	
	float l = 1.0f;
	
	if ( mu > 0.2f)
		l = pow(  fabs(a * uv.x + b * uv.y + c ), 1.0f/8.0f );
	else
		l = 2.0f - pow( fabs(a * uv.x + b * uv.y + c), 1.0f/8.0f );				
	
	return mix(0.5f, 1.0f, l);
}

// Generate some blotches.
float randomBlotch(float seed, vec2 iResolution, vec2 uv)
{
	float x = rand(seed);
	float y = rand(seed+1.0f);
	float s = 0.01f * rand(seed+2.0f);
	
	vec2 p = (vec2)(x,y) - uv;
	p.x *= iResolution.x / iResolution.y;
	float a = atan(p.y/p.x);
	float v = 1.0f;
	float ss = s*s * (sin(6.2831f*a*x)*0.1f + 1.0f);
	
	if ( dot(p,p) < ss ) v = 0.2f;
	else
		v = pow(dot(p,p) - ss, 1.0f/16.0f);
	
	return mix(0.3f + 0.2f * (1.0f - (s / 0.02f)), 1.0f, v);
}

__kernel void MAIN(__read_only image2d_t input1,
					__write_only image2d_t dstImg,
					__global FilterParam* param,
					int Fade, 
					int Colorful,
					int Frequency,
					int alpha)
{
	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[0];;
	float iGlobalTime = param->cur_time;
	
	int w = get_global_id(0);
	int h = get_global_id(1);
	float2 resolution = (float2)(W,H);
	int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 tc = ((vec2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f))/resolution.xy;
	vec2 uv = tc; 
	
	 // Set frequency of global effect to 20 variations per second
		float t = (float)((int)(iGlobalTime * FREQUENCY * (float)((Frequency))));
		
		// Get some image movement
		vec2 suv = uv + 0.002f * (vec2)( rand(t), rand(t + 23.0f));
		
		// Get the image
		vec3 image = INPUTSRC(input1, param, (vec2)(suv.x, suv.y) ).xyz;
		
		vec3 oldImage = image;
		if ((Colorful) == 0)
		{
			float luma = dot( (vec3)(0.2126f, 0.7152f, 0.0722f), image );
			oldImage = luma * (vec3)(0.7f, 0.7f, 0.7f);
		}
		
		// Create a time-varyting vignetting effect
		float vI = 16.0f * (uv.x * (1.0f-uv.x) * uv.y * (1.0f-uv.y));
		vI *= mix( 0.7f, 1.0f, rand(t + 0.5f));
		
		// Add additive flicker
		vI += 1.0f + 0.4f * rand(t+8.0f);
		
		// Add a fixed vignetting (independent of the flicker)
		vI *= pow(16.0f * uv.x * (1.0f-uv.x) * uv.y * (1.0f-uv.y), 0.4f);
		
		// Add some random lines (and some multiplicative flicker. Oh well.)
		#ifdef LINES_AND_FLICKER
		int l = (int)(8.0f * rand(t+7.0f));
		
		if ( 0 < l ) vI *= randomLine( t+6.0f+17.f* (0), uv);
		if ( 1 < l ) vI *= randomLine( t+6.0f+17.f* (1), uv);
		if ( 2 < l ) vI *= randomLine( t+6.0f+17.f* (2), uv);		
		if ( 3 < l ) vI *= randomLine( t+6.0f+17.f* (3), uv);
		if ( 4 < l ) vI *= randomLine( t+6.0f+17.f* (4), uv);
		if ( 5 < l ) vI *= randomLine( t+6.0f+17.f* (5), uv);
		if ( 6 < l ) vI *= randomLine( t+6.0f+17.f* (6), uv);
		if ( 7 < l ) vI *= randomLine( t+6.0f+17.f* (7), uv);
		
		#endif
		
		// Add some random blotches.
		#ifdef BLOTCHES
		int s = (int)( max(8.0f * rand(t+18.0f) -2.0f, 0.0f ));

		if ( 0 < s ) vI *= randomBlotch( t+6.0f+19.0f* (0), resolution, uv);
		if ( 1 < s ) vI *= randomBlotch( t+6.0f+19.0f* (1), resolution, uv);
		if ( 2 < s ) vI *= randomBlotch( t+6.0f+19.0f* (2), resolution, uv);
		if ( 3 < s ) vI *= randomBlotch( t+6.0f+19.0f* (3), resolution, uv);
		if ( 4 < s ) vI *= randomBlotch( t+6.0f+19.0f* (4), resolution, uv);
		if ( 5 < s ) vI *= randomBlotch( t+6.0f+19.0f* (5), resolution, uv);
	
		#endif
	
		// Show the image modulated by the defects
        vec3 color = oldImage * vI;
		
		// Add some grain (thanks, Jose!)
		#ifdef GRAIN
        color *= (1.0f+(rand2(uv+t*0.01f)-0.2f)*0.15f);
        #endif
		
		vec4 original = INPUTSRC(input1, param, tc);
		vec4 outCol;
		outCol.xyz = mix(color, original.xyz, (vec3)( 1.0f - (float)((Fade))/300.0f*(float)((alpha))/100.0f ) );
		outCol.w = original.w;
				  
     write_imagef(dstImg, (int2)(w, h), outCol.zyxw );
}